/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.fsp.cmdhelpers.FspCodAsyncEventData;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.objmgr.OmUtils;
import com.ibm.hsc.objmgr.cec.OmCecHscInfoUpdater;
import com.ibm.hsc.objmgr.cec.OmCecInstUpdater;
import com.ibm.hsc.objmgr.cec.OmCecLparsUpdater;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.cec.OmCecStateChangeAct;
import com.ibm.hsc.objmgr.cec.OmCecSysProfsUpdater;
import com.ibm.hsc.objmgr.cec.OmIoResAct;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import java.util.BitSet;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecUpdater {
    private OmCecMgr mCecMgr;
    private OmCecInstUpdater mCecInstUpdater = null;
    private OmCecHscInfoUpdater mCecHscInfoUpdater = null;
    private OmCecLparsUpdater mCecLparsUpdater = null;
    private OmCecSysProfsUpdater mCecSysProfsUpdater = null;
    private OmCecStateChangeAct mCecStateChangeAct = null;
    private OmIoResAct mIoResAct = null;
    private boolean mSentCreationEvent = false;
    private HSCEventIndicationMgr mIndMgr = null;
    private static final int LPAR_CHANGE = 1;
    private static final int LPAR_CPU_MEM_CHANGE = 2;
    private static final int LPAR_RT_CPU_MEM_CHANGE = 4;
    private static final int LPAR_VIO_CHANGE = 8;
    private static final int LPAR_TCPIP_CHANGE = 16;

    OmCecUpdater(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
        this.mCecInstUpdater = new OmCecInstUpdater(this.mCecMgr);
        this.mCecHscInfoUpdater = new OmCecHscInfoUpdater(this.mCecMgr);
        this.mCecLparsUpdater = new OmCecLparsUpdater(this.mCecMgr);
        this.mCecSysProfsUpdater = new OmCecSysProfsUpdater(this.mCecMgr);
        this.mIoResAct = new OmIoResAct(this.mCecMgr);
        this.mCecStateChangeAct = new OmCecStateChangeAct(this.mCecMgr);
        this.mIndMgr = HSCEventIndicationMgr.getInstance();
    }

    void sentCreationEvent() {
        this.mSentCreationEvent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(FspLockHelper fspLockHelper) throws PIHscServerException {
        RObject rObject = (RObject)this.mCecMgr.getObject().clone();
        boolean bl = false;
        try {
            block18: {
                try {
                    bl = this.mCecInstUpdater.update(fspLockHelper);
                    if (this.mCecMgr.isFspAvailable()) {
                        this.mCecLparsUpdater.update();
                        this.mCecSysProfsUpdater.update();
                    }
                    if (this.mCecMgr.isHypervisorRunning()) {
                        this.mCecMgr.getCmdHelper().exchangeVspCapabilities();
                        try {
                            String string = this.mCecMgr.getCecName().replace('*', '_');
                            String string2 = "/opt/hsc/bin/lspartition -c " + string + " -dlparreset";
                            Process process = Runtime.getRuntime().exec(string2);
                            System.out.println(string2);
                            System.out.println("...Done!");
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            System.out.println("lspartition call failed!");
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                        }
                        this.mCecHscInfoUpdater.pushHscInfo();
                        this.mCecLparsUpdater.update();
                        this.mIoResAct.rebuildSlotsCommon();
                        this.mCecSysProfsUpdater.update();
                        System.out.println("Rebuild finished successfully");
                        break block18;
                    }
                    System.out.println("Rebuild failed because PHYP is down");
                }
                catch (Throwable throwable) {
                    System.out.println("OmCecUpdater: rebuild error found");
                    throwable.printStackTrace();
                    String string = this.rebuildError(throwable);
                    if (string != null) {
                        throw new PIHscServerException(string);
                    }
                    Object var8_11 = null;
                    if (!this.mSentCreationEvent) {
                        this.mIndMgr.sendIndication(1, this.mCecMgr.getObject(), null);
                        this.mSentCreationEvent = true;
                    } else if (bl) {
                        this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
                    }
                    System.out.println("End Of rebuild cec");
                }
            }
            Object var8_10 = null;
            if (!this.mSentCreationEvent) {
                this.mIndMgr.sendIndication(1, this.mCecMgr.getObject(), null);
                this.mSentCreationEvent = true;
            } else if (bl) {
                this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
            }
            System.out.println("End Of rebuild cec");
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!this.mSentCreationEvent) {
                this.mIndMgr.sendIndication(1, this.mCecMgr.getObject(), null);
                this.mSentCreationEvent = true;
            } else if (bl) {
                this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
            }
            System.out.println("End Of rebuild cec");
            throw throwable;
        }
    }

    private String rebuildError(Throwable throwable) {
        String string = "";
        String string2 = "";
        int n = -1;
        try {
            string = this.mCecMgr.getCecName();
            string2 = this.mCecMgr.getIPAddress();
            n = this.mCecMgr.getVPort();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        System.out.println(">>>>>>>>>>>>> REBUILD ERROR: INCOMPLETE STATE: mCecMgr = " + this.mCecMgr + " cecName = " + string + " ipAddr = " + string2 + " vport = " + n);
        try {
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)this.mCecMgr.getObject().getProperty(R50ComputerSystem.Index_State);
            if ((unsignedInt8 == null || unsignedInt8.shortValue() != 251) && this.mCecMgr.getCecStateChangeAct().setCecState(-1, 253)) {
                System.out.println("OmCecUpdater: put cec into incomplete state");
                this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
            }
        }
        catch (RException rException) {
            return "2521";
        }
        if (throwable instanceof RException) {
            return "2521";
        }
        if (throwable instanceof PIHscCmdMgrException) {
            // empty if block
        }
        return null;
    }

    RObjectId createCecInst() throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_ComputerSystem);
        String string = this.mCecMgr.getCecName();
        rObjectId.setKeyValue(0, string);
        rObjectId.setKeyValue(1, "IBMHSC_ComputerSystem");
        RObject rObject = new RObject(rObjectId);
        rObject.setProperty(R50ComputerSystem.Index_PlatformType, (Object)string.substring(0, string.indexOf("*")));
        rObject.setProperty(R50ComputerSystem.Index_PlatformSerial, (Object)string.substring(string.indexOf("*") + 1));
        rObject.addInstance();
        return rObjectId;
    }

    public int getCecState() throws PIHscServerException, PIHscCmdMgrException {
        return this.mCecStateChangeAct.getCecStateFromFspAndPhyp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildCecName() {
        try {
            String string = this.mCecMgr.getCmdHelper().getCecName();
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            if (this.mCecMgr.getObject().setProperty(R50ComputerSystem.Index_UserDefinedName, (Object)string)) {
                this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildAvailRes() {
        try {
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            if (this.mCecInstUpdater.updatePhypAvailResData()) {
                this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildChangedNvram(FspLockHelper fspLockHelper) {
        try {
            boolean bl = false;
            if (!this.mCecMgr.isHypervisorRunning() || this.mCecMgr.getSaveArea() == null) {
                return;
            }
            try {
                bl = this.mCecMgr.getSaveArea().rebuildNVRAM(this.mCecMgr.getFspVersion(), fspLockHelper);
            }
            catch (Throwable throwable) {
                RObject rObject = (RObject)this.mCecMgr.getObject().clone();
                if (this.mCecMgr.getCecStateChangeAct().setCecState(-1, 251)) {
                    System.out.println("OmCecUpdater: build nvram err, put cec into recovery state");
                    this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
                }
                return;
            }
            System.out.println("Did the save area change? " + bl + ". If so, rebuild LPARs and SysProfs");
            if (bl) {
                boolean bl2 = this.mCecLparsUpdater.update();
                this.mCecSysProfsUpdater.update();
                if (bl2) {
                    this.mIoResAct.rebuildSlotsCommon(true);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.rebuildError(throwable);
        }
    }

    void rebuildChangedIoInfo(Vector vector, Vector vector2) {
        try {
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray = (String[])vector.elementAt(i);
                    this.mIoResAct.ioDrawerChanged(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
            if (vector2 != null && vector2.size() > 0) {
                this.mIoResAct.busesChanged(vector2);
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildIoDrawers() {
        try {
            this.mIoResAct.updateIoDrawers();
            System.out.println("finished io drawer update, bef slot common update");
            this.mIoResAct.rebuildSlotsCommon();
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildPhypStates() {
        try {
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            if (this.mCecInstUpdater.updateCecHypervisorStateData(true)) {
                this.mIndMgr.sendIndication(4, this.mCecMgr.getObject(), rObject);
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    void rebuildChangedLparVsps(int n) {
        OmLparMgr omLparMgr = this.getLparMgr(n);
        if (omLparMgr == null) {
            return;
        }
        try {
            omLparMgr.getLparInstUpdater().updateVspChanges();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.rebuildError(throwable);
        }
    }

    void rebuildChangedLparVspSrcs(int n) {
        OmLparMgr omLparMgr = this.getLparMgr(n);
        if (omLparMgr == null) {
            return;
        }
        try {
            omLparMgr.getLparInstUpdater().updateVspSrcChange(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.rebuildError(throwable);
        }
    }

    private OmLparMgr getLparMgr(int n) {
        String string;
        OmLparMgr omLparMgr = null;
        try {
            string = OmUtils.getInstance().getLparName(n, this.mCecMgr.getCecName());
            omLparMgr = this.mCecMgr.getLparMgr(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (omLparMgr == null) {
            System.out.println("-----  cannot find lpar mgr, ignore vsp event");
            return null;
        }
        try {
            string = this.mCecMgr.getCmdHelper().getLparSlotDefinitionState(new UnsignedInt16(n));
            if (string.intValue() == 0) {
                System.out.println("----- partition state is undefined, ignore vsp event");
                return null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return omLparMgr;
    }

    void rebuildChangedLpar(int n, int n2) {
        OmLparMgr omLparMgr = this.getLparMgr(n);
        if (omLparMgr == null) {
            return;
        }
        try {
            omLparMgr.getLparInstUpdater().updatePartitionChanges(n2);
            if ((n2 & 8) != 0) {
                omLparMgr.updateLparVirtualIo();
            }
            if ((n2 & 1) != 0) {
                omLparMgr.updateLparIoPool();
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    void rebuildCecSrc() {
        try {
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            if (this.mCecInstUpdater.updateCecSrc()) {
                this.mIndMgr.sendIndication(8, this.mCecMgr.getObject(), rObject);
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }

    void rebuildCodChanges(FspCodAsyncEventData fspCodAsyncEventData) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        BitSet bitSet = fspCodAsyncEventData.getEventMask();
        try {
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            if (bitSet.get(2)) {
                bl2 = true;
                if (this.mCecInstUpdater.updateCecCodAsyncMsgList(true, fspCodAsyncEventData)) {
                    bl3 = true;
                }
            }
            if (bitSet.get(3) && this.mCecInstUpdater.updateCecCodOnoffProcState(true)) {
                bl3 = true;
            }
            if (bitSet.get(4) && this.mCecInstUpdater.updateCecCodOnoffMemState(true)) {
                bl3 = true;
            }
            if (bitSet.get(5) && this.mCecInstUpdater.updateCecCodMeteredProcState(true)) {
                bl3 = true;
            }
            if (bitSet.get(6)) {
                // empty if block
            }
            if (bitSet.get(7) && this.mCecInstUpdater.updateCecCodTrialProcState(true)) {
                bl3 = true;
            }
            if (bitSet.get(8) && this.mCecInstUpdater.updateCecCodTrialMemState(true)) {
                bl3 = true;
            }
            if (bl) {
                System.out.println("*** Sending EVENT_COD_CODE_COMPLETE event");
                this.mIndMgr.sendIndication(128, this.mCecMgr.getObject(), rObject);
            }
            if (bl2) {
                System.out.println("*** Sending EVENT_MSG_DISPLAY event");
                this.mIndMgr.sendIndication(32, this.mCecMgr.getObject(), rObject);
            }
        }
        catch (Throwable throwable) {
            this.rebuildError(throwable);
            throwable.printStackTrace();
        }
    }
}

